#ifndef PROFDIST_LIB_PROTEIN_MAPPER_HPP_INCLUDED
#define PROFDIST_LIB_PROTEIN_MAPPER_HPP_INCLUDED 

/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute *
 *   it and/or modify it under the terms of the GNU General Public License *
 *   as published by the Free Software Foundation; either version 2 of the *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
namespace profdist {

struct protein_mapper 
{
  private:
    unsigned char prot2code[128];
    char code2prot[22];
    protein_mapper();
  public:
    static protein_mapper& get_instance();
    inline unsigned char to_code( char protein ) const 
    { return prot2code[protein]; }
    inline char to_protein( unsigned char code ) const 
    { return code2prot[code]; }
};

}
#endif

