/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <fstream>
#include "aligncode.h"
#include "profile.h"
#include "parser.h"
#include "tree.h"
#include "traits.hpp"

using namespace std; 
using namespace profdist; 
typedef list<list<size_t > > prof_list_type;
void get_profiles( prof_list_type & profs, size_t num ) {
  set<size_t> rest;
  for( size_t i = 0; i < num; ++i)
    rest.insert(i);

  for(string input = "go on";input != "end";cin >> input){
    list<size_t> l;
    for( int seq = -1; (cin >> seq) && seq != -1 && seq < num;  
        l.push_back(seq), cout << "Adding sequence "<<seq<<" to list"<< endl )
      rest.erase(rest.find(seq));
    profs.push_back(l);
  }

  for( set<size_t>::const_iterator it = rest.begin(); it != rest.end(); ++ it ) {
    list<size_t> l;
    l.push_back( *it );
    profs.push_back( l );
  }
}
void  copy_profiles( tree_types::profile_map & known_profiles, prof_list_type const& profiles ){
  std::size_t i = 0;
  for( prof_list_type::const_iterator it = profiles.begin(), e = profiles.end(); e != it; ++it ) {
    if(it->size() > 1 ) {
      Node::set_type data;
      copy( it->begin(), it->end(), inserter(data,data.begin()));
      known_profiles[i] = Node::ptr(new Node( data,0, i) ) ;
    }
    else {
      known_profiles[i] = Node::ptr(new Node( *it->begin()) ) ;
    }
    ++i;
  }
}

int main( int argc, char** argv )
{
  if( argc == 2 )
  {
    profdist::alignment sequences;
    parse_fasta( argv[1], sequences );

    profdist::AlignCode<rna_traits> code;
    code.read_sequences( sequences );

    cout << "Seq:" << code << endl;

    prof_list_type  profiles;
    get_profiles(profiles, code.get_num_sequences() );

   
    cout << "Building profiles " << endl;
    profdist::Profile prof(sequences,profdist::rna_traits(), profiles);
    cout << prof << endl;

    while(true)
    {
      
      prof_list_type profiles;
      get_profiles(profiles, prof.get_num_profiles() );
      if( profiles.empty() )      break;

      tree_types::profile_map profiles_found;
      copy_profiles( profiles_found, profiles );

      prof.refine( profiles_found );

      cout << prof << endl;
    }
  }
}

