#include "matrix_eigenvalues_cache.h"
#include "qvtml.h"

namespace profdist {

MatrixEigenvaluesCache::MatrixEigenvaluesCache()
{
	loadQVTML();
}

MatrixEigenvaluesCache::~MatrixEigenvaluesCache()
{
	
}

void MatrixEigenvaluesCache::loadQVTML()
{
	MatrixInfo<double, ratematrix::qvtml::Rows, ratematrix::qvtml::Rows> info;
	loadMatrixFromArray(info.matrix, ratematrix::qvtml::matrix);
	loadMatrixFromArray(info.U, ratematrix::qvtml::U);
	loadMatrixFromArray(info.lambda, ratematrix::qvtml::lambda);
	loadMatrixFromArray(info.U_inv, ratematrix::qvtml::U_inv);
	insert(info);
}

MatrixEigenvaluesCache& getEigenvaluesCache()
{
	static MatrixEigenvaluesCache cache;
	return cache;
}

} // namespace profdist
