//---------------------------------------------------------------------------
// mapDef
//---------------------------------------------------------------------------
#include <map>
#include <set>

//---------------------------------------------------------------------------
// DEFINES, MAKROS
//---------------------------------------------------------------------------
#if !defined(mapDef_H)
  #define mapDef_H

typedef std::set < unsigned int> setType;
typedef setType::const_iterator iterSetType;


// structure to compare sets
struct eqSet
{
  bool operator() ( setType const& A, setType const& B ) const
  {
    bool returnValue = false;

    iterSetType iterSetA;
    iterSetType iterSetB;

    iterSetA = A.begin();
    iterSetB = B.begin();

    if ( A.size() < B.size() )
      returnValue = true;
    else if ( A.size() > B.size() )
      returnValue = false;
    else
    {
      while ( iterSetA != A.end() && iterSetB != B.end() )
      {
        if ( * iterSetA == * iterSetB )
        {
          ++iterSetA;
          ++iterSetB;
        }
        else if ( * iterSetA < * iterSetB )
        {
          returnValue = true;
          iterSetA = A.end();
          iterSetB = B.end();
          continue;
        }
        else
        {
          iterSetA = A.end();
          iterSetB = B.end();
          continue;
        }
      } //end of while
    } // end of else
    return returnValue;
  }
};





#endif // mapDef_H
