/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <cstring>
#include "dnamapper.h"

DNAMapper::DNAMapper()
{
  std::memset( dna2code, 5, 128);
  std::memset( code2dna, 'N',6);
  dna2code[0] = 0;
  dna2code[1] = 1;
  dna2code[2] = 2;
  dna2code[3] = 3;
  dna2code[4] = 4;
  
  dna2code['A'] = 0;
  dna2code['a'] = 0;
  dna2code['C'] = 1;
  dna2code['c'] = 1;
  dna2code['G'] = 2;
  dna2code['g'] = 2;
  dna2code['U'] = 3;
  dna2code['u'] = 3;
  dna2code['T'] = 3;
  dna2code['t'] = 3;
  dna2code['-'] = 4;

  code2dna[0] = 'A';
  code2dna[1] = 'C';
  code2dna[2] = 'G';
  code2dna[3] = 'T';
  code2dna[4] = '-';
  code2dna[5] = 'N';
}

DNAMapper& get_mapper_instance()
{
  static DNAMapper instance;
  return instance;
}


