#include <iostream>
#include <fstream>
#include <sstream>
#include <iterator>
#include <algorithm>
#include "parser.h"
#include "ct_parser.h"

int main( int argc, char ** argv )
{

  using namespace profdist;
  using namespace std;
  if( argc != 1 )
  {
    alignment seqs;
    try {
      profdist::parse_ct( argv[1], seqs );
    }
    catch( runtime_error const& e ) { 
      cout << e.what();
      return 1;
    }
    for( alignment::const_iterator it = seqs.begin(), e = seqs.end();
        it != e; ++it)
    {
      cout << "ID:" << string(it->id.first, it->id.second) << endl;
      cout << "CLASSIFCATION:" << endl;
      for( list<alignment::value_type::string_range>::const_iterator _it = it->classification.begin(),
          _e = it->classification.end();
          _it != _e; ++_it )
        cout << '|' << string(_it->first, _it->second ) << "|";
      cout << endl << "SEQUENCE:" << endl;
      for( list<alignment::value_type::string_range>::const_iterator _it = it->sequence_data.begin(),
          _e = it->sequence_data.end();
          _it != _e; ++_it )
        cout << '|' << string(_it->first, _it->second ) << "|";
      cout << endl;
      cout << endl << "Folding:" << endl;
      copy( it->fold_data.begin(), it->fold_data.end(),  
          ostream_iterator<size_t>( cout, ", " ) );

      cout << endl;
    }
  }
  else 
  {
    cout << "File name required!" << endl; 
  }
}

