/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CBCANALYZER_CBCS_H_INCLUDED
#define CBCANALYZER_CBCS_H_INCLUDED

#include <set>
/**
 * This class implements the basic cbc detection concept. 
 * In this implementation certain combinations of UACG in both sequences 
 * are detected as compensatory base changes. Detection will yield 
 * 1 as accumulative distance.  
 *
 * \par Example:
 * For the following example CbcDetector will detect a compensatory base change at the positions 
 * marked in these two sequences.
 * \verbatim
 * XXXCXXGXX
 * ooo(..)oo
 * XXXUXXAXX
 * ooo(())oo
 * \endvarbatim
 * 
 *
 */
struct CbcDetector 
{
  typedef std::pair<char,char> c_pair;
  typedef std::pair<c_pair,c_pair> f_pair;
  std::set<f_pair> cbc_info;

  CbcDetector();
  /**
   * \param[in] seq1_base1  first element in first sequence
   * \param[in] seq1_base2  second element in first sequence
   * \param[in] seq2_base1  first element in second sequence
   * \param[in] seq2_base2  second element in second sequence
   * \return the distance to accumulate for this compensatory base change or zero.
   */
  std::size_t operator()( char seq1_base1, char seq1_base2, char seq2_base1, char seq2_base2 ) const;
};

#endif
