/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <stdexcept>
#include "aligncode.h"
#include "bootstrap.h"
#include "distance.h"
#include "parser.h"
using namespace std;
using namespace profdist;

void print_contents( profdist::alignment const& seq ) 
{
    for( profdist::alignment::const_iterator it = seq.begin(), e = seq.end();
        it != e; ++it)
    {
      cout << "ID:" << string(it->id.first, it->id.second) << endl;
      cout << "CLASSIFCATION:" << endl;
      for( list<alignment::value_type::string_range>::const_iterator _it = it->classification.begin(),
          _e = it->classification.end();
          _it != _e; ++_it )
        cout << '|' << string(_it->first, _it->second ) << "|";
      cout << endl << "SEQUENCE:" << endl;
      for( list<alignment::value_type::string_range>::const_iterator _it = it->sequence_data.begin(),
          _e = it->sequence_data.end();
          _it != _e; ++_it )
        cout << '|' << string(_it->first, _it->second ) << "|";
      cout << endl;
    }
}

int main( int argc, char ** argv)
{
  if( argc != 1 )
  {
    alignment seq;
    try { 
      parse_fasta( argv[1], seq );
    }
    catch ( runtime_error & e )
    {
      cout << e.what() << endl;
    }

    print_contents( seq );

    cout << endl << endl << "Now initializing Aligncode Object!"  << endl;

    AlignCode<rna_traits> code(2,3);
   // AlignCode code;
    cout << code;
    cout << code.get_matrix(0);
    code.resize(3,11);
    cout << code;
    code.read_sequences( seq );
    cout << code.get_matrix(0);
/*    code.resize(2,10);
    cout << code;
    cout << code.get_matrix(0);
    code.resize(3,15);
    cout << code;
    cout << code.get_matrix(0);
    cout << code.get_matrix(1);

    modify( code );
    cout << code;
    cout << code.get_matrix(0);
    cout << code.get_matrix(1);

    cout << code.get_matrix(0);*/

    AlignCode<rna_traits> other;
    bootstrap( code, other );
    cout << other;
    cout << other.get_matrix(0);
    
  }
  else {
    cout << "Add a file name to the command to test the embl parser" << endl;

  }

}
