#include "workspace_tree_model.hpp"

namespace gui {

	RootItem::RootItem() : DataItem() {}
	unsigned int RootItem::type() const { return 0; }
	bool RootItem::readData(const std::string& fileName, profdist::FileType fileType) { return false; }
	bool RootItem::writeData(std::ostream& out, profdist::FileType fileType) { return false; }
	QString RootItem::dataToString() const { return QString(); }
	
	/*
	 * WorkspaceTreeModel:
	 */
	WorkspaceTreeModel::WorkspaceTreeModel(QObject* parent)
	: QAbstractItemModel(parent), _root(new RootItem())
	{}
	
	WorkspaceTreeModel::~WorkspaceTreeModel()
	{
		if(_root)
			delete _root;
	}
	
	QModelIndex WorkspaceTreeModel::treeNodeToIndex(const ConcreteTreeItem* node) const
	{
		if(!node || node == _root)
			return QModelIndex();
		return createIndex(node->index(), 0, const_cast<ConcreteTreeItem*>(node));
	}
	
	WorkspaceTreeModel::ConcreteTreeItem* WorkspaceTreeModel::indexToTreeNode(const QModelIndex& index) const
	{
		if(!index.isValid())
			return _root;
		return static_cast<ConcreteTreeItem*>(index.internalPointer());
	}
	
	int WorkspaceTreeModel::columnCount(const QModelIndex& /*parent*/) const
	{
		return 2;
	}
	
	QVariant WorkspaceTreeModel::data(const QModelIndex& index, int role) const
	{
		if(!index.isValid())
			return QVariant();
		ConcreteTreeItem* node = static_cast<ConcreteTreeItem*>(index.internalPointer());
		if(node)
		{
			switch(index.column())
			{
				case 0:
				{
					switch(role)
					{
						case Qt::DisplayRole: return QVariant(QString(node->name()));
						case Qt::DecorationRole: return node->icon();
					}
				}
				case 1:
				{
					switch(role)
					{
						case Qt::DisplayRole: return node->info();
					}
				}
				/*
				case 2:
				{
					switch(role)
					{
						case Qt::DisplayRole: return node->id();
					}
				}
				*/
			}
		}
		return QVariant();
	}
	
	QVariant WorkspaceTreeModel::headerData(int section, Qt::Orientation orientation, int role) const
	{
		if(section == 0 && orientation == Qt::Horizontal && role == Qt::DisplayRole)
		{
			return tr("Alignment Workspace");
		}
		else if(section == 1 && orientation == Qt::Horizontal && role == Qt::DisplayRole)
		{
			return tr("Info");
		}
		/*
		else if(section == 2 && orientation == Qt::Horizontal && role == Qt::DisplayRole)
		{
			return tr("ID");
		}
		*/
		return QVariant();
	}
	
	QModelIndex WorkspaceTreeModel::index(int row, int column, const QModelIndex& p) const
	{
		ConcreteTreeItem* parent = indexToTreeNode(p);
		ConcreteTreeItem* node = parent->child(row);
		if(!node)
			return QModelIndex();
		return createIndex(row, column, node);
	}
	
	QModelIndex WorkspaceTreeModel::parent(const QModelIndex& index) const
	{
		ConcreteTreeItem* node = indexToTreeNode(index);
		return treeNodeToIndex(node->parent());
	}
	
	int WorkspaceTreeModel::rowCount(const QModelIndex& parent) const
	{
		ConcreteTreeItem* node = indexToTreeNode(parent);
		return node->childCount();
	}
	
	Qt::ItemFlags WorkspaceTreeModel::flags(const QModelIndex& index) const
	{
		if(!index.isValid())
			return Qt::ItemIsEnabled;
		
		return QAbstractItemModel::flags(index) | Qt::ItemIsEditable;
	}
	
	bool WorkspaceTreeModel::setData(const QModelIndex& index, const QVariant& value, int role)
	{
		if (index.isValid() && role == Qt::EditRole) {
			ConcreteTreeItem* node = indexToTreeNode(index);
			if(!node)
				return false;
			node->setName(value.toString());
			emit dataChanged(index, index);
			return true;
		}
		return false;
	}
	
	void WorkspaceTreeModel::addNode(ConcreteTreeItem* new_node, ConcreteTreeItem* parent)
	{
		if(!new_node)
			return;
		if(!parent)
			parent = _root;
		QModelIndex p = treeNodeToIndex(parent);
		beginInsertRows(p, parent->childCount(), parent->childCount());
		parent->addChild(new_node);
		endInsertRows();
		emit expandNode(p);
	}
	
	void WorkspaceTreeModel::removeNode(ConcreteTreeItem* node)
	{
		if(!node || node == _root)
			return;
		
		ConcreteTreeItem* parent = node->parent();
		
		if(!parent)
			parent = _root;
		
		QModelIndex p = treeNodeToIndex(parent);
		size_t index = node->index();
		beginRemoveRows(p, index, index);
		/*
		 * If this node is in use by any other task do not delete it. This node
		 * is deleted later by the process which decrements the use counter
		 * to 0.
		 */
		if(node->useCount() == 0)
			delete node;
		endRemoveRows();
	}
	
}

