#ifndef PROFDIST_QTGUI_VIEWER_HPP_
#define PROFDIST_QTGUI_VIEWER_HPP_

#include <QDialog>
#include <QList>
#include <QIcon>
#include <QString>
#include <QTemporaryFile>

class QTextEdit;
class QProcess;

namespace gui {
	
	class Viewer {
		public:
			virtual ~Viewer() {}
			virtual Viewer* clone(const QString& name, const QIcon& icon, QWidget* parent = 0) const = 0;
			virtual void setData(const QString& data) = 0;
			virtual void show(bool modal = true) = 0;
	};
	
	class ViewerFactory {
		public:
			virtual ~ViewerFactory() {}
			virtual Viewer* getPrototype() const = 0;
			virtual QList<unsigned int> types() const = 0;
	};
	
	class SimpleViewer : public Viewer, public QDialog {
		public:
			SimpleViewer(const QString& name = "", const QIcon& icon = QIcon(), QWidget* parent = 0);
			Viewer* clone(const QString& name, const QIcon& icon, QWidget* parent = 0) const;
			void setData(const QString& data);
			void show(bool modal = true);
		private:
			QTextEdit			*_text_edit;
	};
	
	class SimpleViewerFactory : public ViewerFactory {
		public:
			Viewer* getPrototype() const;
			QList<unsigned int> types() const;
	};
	
	class ExternViewer : public Viewer {
		public:
			ExternViewer(const QString& name = "", const QIcon& icon = QIcon(), QWidget* parent = 0);
			~ExternViewer();
			Viewer* clone(const QString& name, const QIcon& icon, QWidget* parent = 0) const;
			void setData(const QString& data);
			void show(bool modal = true);
		private:
			QTemporaryFile			_tmp_file;
			QString					_tmp_file_name;
			QProcess				*_process;
			QString					_data;
	};
	
	class ExternViewerFactory : public ViewerFactory {
		public:
			Viewer* getPrototype() const;
			QList<unsigned int> types() const;
	};
	
}

#endif // PROFDIST_QTGUI_VIEWER_HPP_
