#include "settings_dialog.hpp"
#include <QSettings>
#include <QFileDialog>
#include <QItemSelectionModel>
#include <QModelIndex>
#include <QHeaderView>
#include "debug.hpp"

namespace gui {
	
#if 0
	TableModel::TableModel()
	{
		QSettings settings;
		QStringList viewers = settings.value("settings/tree_viewer").toStringList();
		_viewers.resize(viewers.size());
		
		int i = 0;
		foreach(QString s, viewers)
		{
			bool multipleView = s.endsWith("[m]");
			s.remove(QRegExp("\\[m\\]"));
			entry e = std::make_pair(s, multipleView);
			_viewers[i] = e;
			i++;
		}
	}
	
	QVariant TableModel::data(const QModelIndex& index, int role) const
	{
		if(!index.isValid())
			return QVariant();
		
		switch(role)
		{
			case Qt::DisplayRole:
			{
				if(index.column() == 0)
					return QVariant(_viewers[index.row()].first);
				break;
			}
			case Qt::CheckStateRole:
			{
				if(index.column() == 1)
					return QVariant(_viewers[index.row()].second ? Qt::Checked : Qt::Unchecked);
				break;
			}
		}
		
		return QVariant();
	}
	
	QVariant TableModel::headerData(int section, Qt::Orientation orientation, int role) const
	{
		if(section == 0 && orientation == Qt::Horizontal && role == Qt::DisplayRole)
			return QVariant("Viewer");
		if(section == 1 && orientation == Qt::Horizontal && role == Qt::DisplayRole)
			return QVariant("Multiple Sequences");
		else
			return QVariant();
	}
	
	Qt::ItemFlags TableModel::flags(const QModelIndex& index) const
	{
		if(!index.isValid())
			return Qt::ItemIsEnabled;
		
		if(index.column() == 1)
			return QAbstractItemModel::flags(index) | Qt::ItemIsUserCheckable;
		else
			return QAbstractItemModel::flags(index);
	}
	
	int TableModel::rowCount(const QModelIndex&) const
	{
		return _viewers.size();
	}
	
	int TableModel::columnCount(const QModelIndex&) const
	{
		return 2;
	}
	
	void TableModel::addViewer(const QString& fileName)
	{
		_viewers.push_back(std::make_pair(fileName, false));
	}
#endif
	
	
	SettingsDialog::SettingsDialog(QWidget* parent)
	: QDialog(parent)
	{
		setupUi(this);
		
		QSettings settings;
		
		int defaultViewer = settings.value("tree_viewer/selected").toInt();
		
		QString treeView = settings.value("tree_viewer/tv").toString();
		QString njPlot = settings.value("tree_viewer/njplot").toString();
		
		_line_edit_tree_view->setText(treeView);
		_line_edit_njplot->setText(njPlot);
		
		switch(defaultViewer)
		{
			case 1: _radio_button_tree_view->setChecked(true); break;
			case 2: _radio_button_njplot->setChecked(true); break;
			default: _radio_button_none->setChecked(true);
		}
		
		
		connect(_tool_button_tv, SIGNAL(clicked()), this, SLOT(openDialogTreeView()));
		connect(_tool_button_njplot, SIGNAL(clicked()), this, SLOT(openDialogNjPlot()));
		connect(buttonBox, SIGNAL(accepted()), this, SLOT(okPressed()));
	}
	
	void SettingsDialog::openDialogTreeView()
	{
		QSettings settings;
		QFileInfo info = QFileInfo(settings.value("tree_viewer/tv").toString());
		
		QString fileName = QFileDialog::getOpenFileName(
			0,
			QObject::tr("Select TreeView binary"),
			info.absolutePath());
		
		_line_edit_tree_view->setText(fileName);
	}
	
	void SettingsDialog::openDialogNjPlot()
	{
		QSettings settings;
		QFileInfo info = QFileInfo(settings.value("tree_viewer/njplot").toString());
		
		QString fileName = QFileDialog::getOpenFileName(
				0,
				QObject::tr("Select NjPlot binary"),
				info.absolutePath());
		
		_line_edit_njplot->setText(fileName);
	}
	
	void SettingsDialog::okPressed()
	{
		int selected = 0;
		if(_radio_button_tree_view->isChecked())
			selected = 1;
		else if(_radio_button_njplot->isChecked())
			selected = 2;
		QSettings settings;
		settings.setValue("tree_viewer/selected", selected);
		settings.setValue("tree_viewer/tv", _line_edit_tree_view->text());
		settings.setValue("tree_viewer/njplot", _line_edit_njplot->text());
		accept();
	}
	
	
#if 0	
	SettingsDialog::SettingsDialog(QWidget* parent)
	: QDialog(parent)
	{
		setupUi(this);
		
		QSettings settings;
		QStringList viewer = settings.value("settings/tree_viewer").toStringList();
		
		_list_widget->insertItems(0, viewer);
		
		connect(_tool_button_open, SIGNAL(clicked()), this, SLOT(newViewer()));
		connect(_tool_button_remove, SIGNAL(clicked()), this, SLOT(removeViewer()));
		connect(_tool_button_up, SIGNAL(clicked()), this, SLOT(moveUp()));
		connect(_tool_button_down, SIGNAL(clicked()), this, SLOT(moveDown()));
		connect(okButton, SIGNAL(clicked()), this, SLOT(okPressed()));
	}
	
	void SettingsDialog::newViewer()
	{
		QSettings settings;
		QString fileName = QFileDialog::getOpenFileName(
			this,
			tr("Select Tree-Viewer Executable"),
			settings.value("settings/tree_viewer_path").toString());
		
		if(fileName.isNull())
		{
			return;
		}
		
		QDir dir(fileName);
		dir.cdUp();
		settings.setValue("settings/tree_viewer_path", dir.path());
		_list_widget->addItem(fileName);
		
		
	}
	
	void SettingsDialog::removeViewer()
	{
		
		QList<QListWidgetItem*> items = _list_widget->selectedItems();
		if(items.empty())
			return;
		delete _list_widget->takeItem(_list_widget->row(items.front()));
		_list_widget->update();
	}
	
	void SettingsDialog::moveUp()
	{
		QList<QListWidgetItem*> items = _list_widget->selectedItems();
		if(items.empty())
			return;
		
		int row = _list_widget->row(items.front());
		
		if(row == 0)
			return;
		
		_list_widget->takeItem(row);
		_list_widget->insertItem(--row, items.front());
		
		items.front()->setSelected(true);
	}
	
	void SettingsDialog::moveDown()
	{
		QList<QListWidgetItem*> items = _list_widget->selectedItems();
		if(items.empty())
			return;
		
		int row = _list_widget->row(items.front());
		
		if(row == _list_widget->model()->rowCount() - 1)
			return;
		
		_list_widget->takeItem(row);
		_list_widget->insertItem(++row, items.front());
		
		items.front()->setSelected(true);
	}
	
	void SettingsDialog::okPressed()
	{
		QSettings settings;
		QStringList viewer;
		for(int i = 0; i < _list_widget->count(); i++)
		{
			QListWidgetItem* item = _list_widget->item(i);
			viewer << item->text();
		}
		
		settings.setValue("settings/tree_viewer", viewer);
		accept();
	}
#endif
	
#if 0
	SettingsDialog::SettingsDialog(QWidget* parent)
	: QDialog(parent), _model(new TableModel())
	{
		setupUi(this);
		
		QSettings settings;
		QStringList viewer = settings.value("settings/tree_viewer").toStringList();
		
		_table_view->setModel(_model);
		_table_view->setShowGrid(false);
		_table_view->verticalHeader()->hide();
		
		QHeaderView* header = _table_view->horizontalHeader();
		header->setMovable(false);
		header->setClickable(false);
		header->setResizeMode(0, QHeaderView::Stretch);
		header->setResizeMode(1, QHeaderView::ResizeToContents);
		
		connect(_tool_button_open, SIGNAL(clicked()), this, SLOT(newViewer()));
		connect(_tool_button_remove, SIGNAL(clicked()), this, SLOT(removeViewer()));
		connect(_tool_button_up, SIGNAL(clicked()), this, SLOT(moveUp()));
		connect(_tool_button_down, SIGNAL(clicked()), this, SLOT(moveDown()));
		connect(okButton, SIGNAL(clicked()), this, SLOT(okPressed()));
	}
	
	void SettingsDialog::newViewer()
	{
		QSettings settings;
		QString fileName = QFileDialog::getOpenFileName(
				this,
				tr("Select Tree-Viewer Executable"),
				settings.value("settings/tree_viewer_path").toString());
		
		if(fileName.isNull())
		{
			return;
		}
		
		QDir dir(fileName);
		dir.cdUp();
		settings.setValue("settings/tree_viewer_path", dir.path());
		
		_model->addViewer(fileName);
	}
	
	void SettingsDialog::removeViewer()
	{
		
	}
	
	void SettingsDialog::moveUp()
	{
	}
	
	void SettingsDialog::moveDown()
	{
	}
	
	void SettingsDialog::okPressed()
	{
		QSettings settings;
		QStringList viewer;
// 		for(int i = 0; i < _list_widget->count(); i++)
// 		{
// 			QListWidgetItem* item = _list_widget->item(i);
// 			viewer << item->text();
// 		}
		
		settings.setValue("settings/tree_viewer", viewer);
		accept();
	}
#endif
	
}
