#ifndef PROFDIST_QTGUI_OPERATION_INTERFACE_HPP_
#define PROFDIST_QTGUI_OPERATION_INTERFACE_HPP_

#include <string>
#include <string>
#include <cstring>
#include <QMutex>
#include <QWaitCondition>
#include <boost/shared_ptr.hpp>

class QString;

namespace gui {
	
	class DataItem;
	class Workspace;
	class ProgressSink;
	class Task;
	class GuiHandleData;
	
	class OperationInterface {
		public:
										OperationInterface();
			
			virtual						~OperationInterface();
			virtual void				execute() = 0; ///< Starts the execution of this operation. The operating code has to be placed here.
			void						cancel(); ///< Cancels the execution of the operation.
			bool						isCanceled() const; ///< @return Returns true if the operation has been canceled.
			void						pause(int guiHandleId, GuiHandleData* data); ///< Pauses the execution of the thread to wait for example on user input through the gui.
			virtual OperationInterface*	clone() = 0; ///< Returns a clone of this object.
			virtual	bool				setDataItem(DataItem* item) = 0; ///< Sets the data item this operation object is operating on. @return Returns false if item couldn't be casted successfully into the correct data type.
			void						setTask(Task* task); ///< Sets the Task object.
			Task*						task(); ///< Returns the task object associated with this OperationInterface object.
			virtual bool				preExecution(); ///< Method which is performed directly before the execution method is called. Code can be placed here by derived classes to perform actions directly before the operation is triggered.
			void						addDataItem(DataItem* newNode, DataItem* parentNode = 0);
			
		protected:
			size_t						maximumValue() const;
			void						setMaximumValue(size_t maximumValue); ///< Sets the maximum value that is used for displaying the progress.
			void						updateProgress(size_t value); ///< Updates the progress value.
			void						updateProgress(const QString& message); ///< Updates the progress message.
			void						showErrorMessage(const std::string& message);
			void						showErrorMessage(const QString& message);
		
		private:
			bool						_do_cancel;
			Task						*_task;
			QMutex						_mutex_pause_condition;
			QWaitCondition				_pause_condition;
			size_t						_maximum_value;
	};
	
}

#endif // PROFDIST_QTGUI_OPERATION_INTERFACE_HPP_

