#ifndef PROFDIST_QTGUI_NEIGHBOUR_JOINING_DATA_HPP_
#define PROFDIST_QTGUI_NEIGHBOUR_JOINING_DATA_HPP_

#include "operation_accessors.hpp"
#include <list>

namespace gui {
	
	class NeighbourJoiningData : public DataForConsensus {
		public:
			NeighbourJoiningData(
				const QString& name,
				const std::vector<std::string>& trees,
				const std::vector<std::string>& sequenceNames);
			unsigned int type() const;
			QIcon icon() const;
			QString info() const;
			QString dataToString() const;
			bool writeData(std::ostream& out, profdist::FileType type);
			size_t getNumTrees() const;
			std::vector<std::string> getTrees() const;
			std::vector<std::string> getSequenceNames() const;
			
		private:
			std::vector<std::string>		_trees;
			std::vector<std::string>		_sequence_names;
	};
	
}

#endif // PROFDIST_QTGUI_NEIGHBOUR_JOINING_DATA_HPP_
