#include "neighbour_joining_data.hpp"
#include "data_type.hpp"

namespace gui {
	
	NeighbourJoiningData::NeighbourJoiningData(
		const QString& name,
		const std::vector<std::string>& trees,
		const std::vector<std::string>& sequenceNames)
	: _trees(trees), _sequence_names(sequenceNames)
	{
		this->setName(name);
	}
	
	unsigned int NeighbourJoiningData::type() const
	{
		return DataType::NjTree;
	}
	
	QIcon NeighbourJoiningData::icon() const
	{
		return _trees.size() > 1 ? QIcon(":/images/64x64/trees.png") : QIcon(":/images/64x64/tree.png");
	}
	
	QString NeighbourJoiningData::info() const
	{
		return QString().setNum(_trees.size()) + QObject::tr(" neighbour joining trees");
	}
	
	QString NeighbourJoiningData::dataToString() const
	{
		std::string data;
		for(std::vector<std::string>::const_iterator i = _trees.begin(), e = _trees.end(); i != e; i++)
		{
			data += (*i);
		}
		return QString(data.c_str());
	}
	
	bool NeighbourJoiningData::writeData(std::ostream& out, profdist::FileType /*type*/)
	{
		for(std::vector<std::string>::const_iterator i = _trees.begin(), e = _trees.end(); i != e; i++)
		{
			out << (*i);
		}
		return true;
	}
	
	size_t NeighbourJoiningData::getNumTrees() const
	{
		return _trees.size();
	}
	
	std::vector<std::string> NeighbourJoiningData::getTrees() const
	{
		return _trees;
	}
	
	std::vector<std::string> NeighbourJoiningData::getSequenceNames() const
	{
		return _sequence_names;
	}
	
}
