#include <QApplication>
#include <QSplashScreen>
#include <QPixmap>
#include <QIcon>
#include "main_window.hpp"
#include "config.h"

using namespace gui;

int main(int argc, char* argv[])
{
	QApplication app(argc, argv);
	
	QCoreApplication::setOrganizationName(PROFDIST_ORGANIZATION_NAME);
	QCoreApplication::setOrganizationDomain(PROFDIST_ORGANIZATION_DOMAIN);
	QCoreApplication::setApplicationName(PROFDIST_APPLICATION_NAME);
	QApplication::setWindowIcon(QIcon(":/images/profdist.png"));
	
	MainWindow mainWindow;
	
	QSplashScreen splash(QPixmap(":/images/bioinf.jpg"));
	
	splash.show();
	splash.showMessage(QObject::tr("Loading plugins ..."));
	
	app.processEvents();
	
	mainWindow.loadPlugins();
	splash.hide();
	
	mainWindow.show();
	
	return app.exec();
}

