#ifndef PROFDIST_QTGUI_HELPER_HPP_
#define PROFDIST_QTGUI_HELPER_HPP_

#include "aligncode.h"
#include "debug.hpp"

#include <iostream>
#include <string>
#include <QString>


namespace gui {
	
	/**
	 * Funktion which returns the string representation of an alignment.
	 * The second template argument can be a string class where the std::string
	 * interface is a subset of this string class. 
	 */
	/*
	template<typename StringType, typename Traits> StringType alignmentToString(const profdist::AlignCode<Traits>& alignCode)
	{
		StringType data;
		
		// Returns the alignment data as a fasta formtatted string
		for(int i = 0, max = alignCode.get_num_sequences(); i < max; i++)
		{
			data.append(">").append(alignCode.get_sequence_name(i).c_str()).append("\n");
				
			int column = 0;
			for(typename profdist::AlignCode<Traits>::const_sequence_iterator iter = alignCode.begin(i), end = alignCode.end(i); iter != end; iter++, column++)
			{
				if(column > 79)
				{
					data.append("\n");
					column = 0;
				}
				data.append(Traits::get_char(*iter));
			}
				
			data.append("\n\n");
		}
		
		return data;
}*/
	
	QString alignmentToQString(const profdist::AlignCode<profdist::rna_structure_traits>& alignCode);
	
	template<typename Traits> QString alignmentToQString(const profdist::AlignCode<Traits>& alignCode)
	{
		QString data;
		
		// Returns the alignment data as a fasta formtatted string
		for(int i = 0, max = alignCode.get_num_sequences(); i < max; i++)
		{
			data.append(">").append(alignCode.get_sequence_name(i).c_str()).append("\n");
				
			int column = 0;
			for(typename profdist::AlignCode<Traits>::const_sequence_iterator iter = alignCode.begin(i), end = alignCode.end(i); iter != end; iter++, column++)
			{
				if(column > 79)
				{
					data.append("\n");
					column = 0;
				}
				data.append(Traits::get_char(*iter));
			}
				
			data.append("\n\n");
		}
		
		return data;
	}
	
	template<typename Traits> bool writeAlignmentToFile(std::ostream& out, const profdist::AlignCode<Traits>& alignCode)
	{
		if(!out)
			return false;
		
		// Returns the alignment data as a fasta formtatted string
		for(int i = 0, max = alignCode.get_num_sequences(); i < max; i++)
		{
			out << ">" << alignCode.get_sequence_name(i) << std::endl;
				
			int column = 0;
			for(typename profdist::AlignCode<Traits>::const_sequence_iterator iter = alignCode.begin(i), end = alignCode.end(i); iter != end; iter++, column++)
			{
				if(column > 79)
				{
					out << "\n";
					column = 0;
				}
				out << Traits::get_char(*iter);
			}
				
			out << "\n\n";
		}
		
		return true;
	}
	
	bool writeAlignmentToFile(std::ostream& out, const profdist::AlignCode<profdist::rna_structure_traits>& alignCode);
	
	/**
	 *
	 */
	void parseAlignmentFromString(char* begin, char* end, profdist::alignment& sequences, const std::string& fileName, const profdist::rna_traits&);
	
	void parseAlignmentFromString(char* begin, char* end, profdist::alignment& sequences, const std::string& fileName, const profdist::protein_traits&);
	
	void parseAlignmentFromString(char* begin, char* end, profdist::alignment& sequences, const std::string& fileName, const profdist::rna_structure_traits&);
	
}

#endif // PROFDIST_QTGUI_HELPER_HPP_
