#ifndef PROFDIST_QTGUI_GUI_HANDLE_
#define PROFDIST_QTGUI_GUI_HANDLE_

namespace gui {
	
	class GuiHandleData;
	
	class GuiHandle {
		public:
			virtual ~GuiHandle();
			virtual void exec(GuiHandleData* data) = 0;
			virtual GuiHandle* clone() = 0;
			
			/* Can only be set once. */
			static void setGuiHandleId(int id);
			static int getGuiHandleId();
			
		private:
			static int		_id;
			static bool		_id_set;
	};
	
	
	class PnjGuiHandle : public GuiHandle {
		public:
			void exec(GuiHandleData* data);
			GuiHandle* clone();
	};
	
}

#endif // PROFDIST_QTGUI_GUI_HANDLE_
