#include "feature.hpp"

#include <QAction>

namespace gui {
	
	Feature::Feature(QAction* action)
	: _action(action)
	{}
	
	Feature::~Feature()
	{
		if(_action)
			delete _action;
	}
	
	QAction* Feature::action()
	{
		return _action;
	}
	
#define IMPLEMENT_NEW_FEATURE(name, icon, label, supported_data_types) \
	name::name() : Feature(new QAction(QIcon(icon), QString(label), 0)) {} \
	bool name::isAvailable(unsigned int type) \
	{ \
	return ((supported_data_types) & type) == type; \
	}
	
	IMPLEMENT_NEW_FEATURE(RnaBootstrapFeature, ":/images/64x64/bootstrap.png", "Bootstrap RNA", DataType::SingleRnaAlignment)
	IMPLEMENT_NEW_FEATURE(RnaStructureBootstrapFeature, ":/images/64x64/bootstrap.png", "Bootstrap RNA Structure", DataType::SingleRnaStructureAlignment)
	IMPLEMENT_NEW_FEATURE(ProteinBootstrapFeature, ":/images/64x64/bootstrap.png", "Bootstrap Protein", DataType::SingleProteinAlignment)
	IMPLEMENT_NEW_FEATURE(RnaDistanceFeature, ":/images/64x64/dodistance.png", "Distance", DataType::SingleRnaAlignment | DataType::RnaBootstrap)
	IMPLEMENT_NEW_FEATURE(RnaStructureDistanceFeature, ":/images/64x64/dodistance.png", "Distance", DataType::SingleRnaStructureAlignment | DataType::RnaStructureBootstrap)
	IMPLEMENT_NEW_FEATURE(ProteinDistanceFeature, ":/images/64x64/dodistance.png", "Distance", DataType::SingleProteinAlignment | DataType::ProteinBootstrap)
	IMPLEMENT_NEW_FEATURE(NeighbourJoiningFeature, ":/images/64x64/neighbour_joining.png", "Neighbour Joining", DataType::DistanceMatrix)
	IMPLEMENT_NEW_FEATURE(ConsensusFeature, ":/images/64x64/consensus.png", "Consensus", DataType::NjTree)
	IMPLEMENT_NEW_FEATURE(RnaProfileNeighbourJoiningFeature, ":/images/profdist.png", "RNA/DNA Profile Neighbour Joining", DataType::SingleRnaAlignment)
	IMPLEMENT_NEW_FEATURE(RnaStructureProfileNeighbourJoiningFeature, ":/images/profdist.png", "RNA/DNA structure Profile Neighbour Joining", DataType::SingleRnaStructureAlignment)
	IMPLEMENT_NEW_FEATURE(ProteinProfileNeighbourJoiningFeature, ":/images/profdist.png", "Protein Profile Neighbour Joining", DataType::SingleProteinAlignment)

#undef IMPLEMENT_NEW_FEATURE

}

