#include "distance_operation.hpp"

namespace gui {
	
	template<> bool DistanceOperation<profdist::rna_traits>::preExecution()
	{
		DistanceDialog dialog(mainWindow);
		int w = dialog.labelAlignmentIcon->width();
		int h = dialog.labelAlignmentIcon->height();
		dialog.labelAlignmentIcon->setPixmap(_data_for_distance->icon().pixmap(w, h));
		dialog.labelAlignmentName->setText(_data_for_distance->name());
	
		if(QDialog::Rejected == dialog.exec())
		{
			return false;
		}
	
		_correction = dialog.correctionModel();
		_matrix_file_name = dialog.lineEditRateMatrix->text();
	
		return true;
	}
	
}
