#include "distance_dialog.hpp"
#include <QFileDialog>
#include <QSettings>
#include "types.h"
#include "config.h"

namespace gui {
	
	DistanceDialog::DistanceDialog(QWidget* p, bool noKimura)
	: QDialog(p), _no_kimura(noKimura)
	{
		setupUi(this);
		if(_no_kimura)
			this->comboBoxCorrectionModel->removeItem(1); // remove the kimura entry
		correctionModelChanged();
		connect(toolButtonFileDialog, SIGNAL(clicked()), this, SLOT(buttonFileDialogPressed()));
		connect(comboBoxCorrectionModel, SIGNAL(currentIndexChanged(int)), this, SLOT(correctionModelChanged()));
	}
	
	profdist::CorrectionModel DistanceDialog::correctionModel() const
	{
		int cm = comboBoxCorrectionModel->currentIndex();
		if(_no_kimura && cm > 0)
			cm += 1;
		return profdist::CorrectionModel(cm);
	}
	
	void DistanceDialog::buttonFileDialogPressed()
	{
		QSettings settings;
		QString dir = settings.value("settings/rate_matrix_open_path").toString();
		if(dir.isNull())
#ifdef Q_OS_WIN32
			dir = QCoreApplication::applicationDirPath();
#else
			dir = PROFDIST_DATA_DIR "/data";
#endif
		QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"),
								dir, tr("All files (*.*)"));
		if(fileName != "")
			lineEditRateMatrix->setText(fileName);
	}
	
	void DistanceDialog::correctionModelChanged()
	{
		bool enabled = (_no_kimura ?
				comboBoxCorrectionModel->currentIndex() == 1 || comboBoxCorrectionModel->currentIndex() == 2 :
				comboBoxCorrectionModel->currentIndex() == 2 || comboBoxCorrectionModel->currentIndex() == 3);
		lineEditRateMatrix->setEnabled(enabled);
		toolButtonFileDialog->setEnabled(enabled);
	}
	
}

