#ifndef PROFDIST_QTGUI_DISTANCE_DATA_HPP_
#define PROFDIST_QTGUI_DISTANCE_DATA_HPP_

#include "operation_accessors.hpp"
#include <vector>

namespace gui {
	
	class DistanceData : public DataForNj {
		public:
			typedef std::vector<profdist::distance_matrix> distance_matrices_t;
			
										DistanceData(
											const QString& name,
											const std::vector<std::string>& sequenceNames,
											const std::vector<profdist::distance_matrix>& distanceMatrices);
										~DistanceData();
			
			bool						writeData(std::ostream& out, profdist::FileType fileType);
			unsigned int				type() const;
			QIcon						icon() const;
			QString						info() const;
			QString						dataToString() const;
			
			sequence_names_t			getSequenceNames() const;
			profdist::distance_matrix	getDistanceMatrix(size_t index) const;
			size_t						getNumMatrices() const;
			
		private:
			std::vector<std::string>	_sequence_names;
			distance_matrices_t			_distance_matrices;
			size_t						_max_name_len;
	};
	
}

#endif // PROFDIST_QTGUI_DISTANCE_DATA_HPP_
