#ifndef PROFDIST_QTGUI_DEBUG_HPP_
#define PROFDIST_QTGUI_DEBUG_HPP_

#ifdef DEBUG_GUI
#  include <iostream>
#  define GUI_MSG(x) std::cout << x << std::flush
#  define GUI_MSG_N(x) std::cout << x << std::endl
#  define GUI_MSG_DESTRUCTOR_ENTER() std::cout << "entering destructor " << __FILE__ << std::endl
#  define GUI_MSG_DESTRUCTOR_LEAVE() std::cout << "leaving destructor " << __FILE__ << std::endl
#else
#  define GUI_MSG(x)
#  define GUI_MSG_N(x)
#  define GUI_MSG_DESTRUCTOR_ENTER()
#  define GUI_MSG_DESTRUCTOR_LEAVE() 
#endif

#ifdef DEBUG_DESTRUCTOR
#  include <iostream>
#  define GUI_MSG_DEST(x) std::cout << x << std::flush
#  define GUI_MSG_DEST_N(className, x) std::cout << #className << "::~" << #className << "(): " << x << std::endl
#  define GUI_MSG_OBJ_DESTROYED(className) GUI_MSG_DEST_N(className, "object destroyed")
#else
#  define GUI_MSG_DEST(x)
#  define GUI_MSG_DEST_N(className, x)
#  define GUI_MSG_OBJ_DESTROYED(className)
#endif

#endif // PROFDIST_QTGUI_DEBUG_HPP_

