#ifndef PROFDIST_QTGUI_BOOTSTRAP_FILE_READER_HPP_
#define PROFDIST_QTGUI_BOOTSTRAP_FILE_READER_HPP_

#include <iostream>
#include <vector>

namespace gui {
	
	template<typename T>
	class ptr_deleter {
		public:
			ptr_deleter(T* ptr) : _ptr(ptr) {}
			~ptr_deleter() { if(_ptr) delete _ptr; }
		private:
			T* _ptr;
	};

	class BootstrapFileReader {
		public:
			BootstrapFileReader(std::istream& is, const std::vector<std::istream::pos_type>& pos);
			
			std::string getData(size_t index);
			
			class data_iterator : std::iterator<std::input_iterator_tag, std::string> {
				public:
					data_iterator(BootstrapFileReader& reader, size_t index) : _reader(reader), _index(index) {}
					
					bool operator==(const data_iterator& iter)
					{
						return (_index == iter._index);
					}
					
					bool operator!=(const data_iterator& iter)
					{
						return !(*this == iter);
					}
					
					value_type operator*()
					{
						if(_index < _reader.pos.size())
							return _reader.getData(_index);
						return value_type();
					}
					
					data_iterator& operator++()
					{
						if(_index < _reader.pos.size())
							_index++;
						return *this;
					}
					
					data_iterator operator++(int)
					{
						if(_index < _reader.pos.size())
							_index++;
						return *this;
					}
				
				private:
					BootstrapFileReader& _reader;
					size_t _index;
			};
			
			typedef data_iterator iterator;
			
			iterator begin() { return iterator(*this, 0); }
			iterator end() { return iterator(*this, pos.size()); }
			
		private:
			friend class data_iterator;
			std::vector<std::istream::pos_type> pos;
			std::istream& is;
	};
	
}

#endif // PROFDIST_QTGUI_BOOTSTRAP_FILE_READER_HPP_

