#include "bootstrap_file_reader.hpp"
#include "debug.hpp"
#include <string>

namespace gui {
	
	BootstrapFileReader::BootstrapFileReader(std::istream& is, const std::vector<std::istream::pos_type>& pos) : is(is), pos(pos)
	{}
	
	std::string BootstrapFileReader::getData(size_t index)
	{
		std::istream::pos_type end_pos;
		
		if(index >= pos.size())
			return std::string();
		else if(index == pos.size() - 1)
			end_pos = is.seekg(0, std::ios_base::end).tellg();
		else
			end_pos = pos[index + 1];
		
		is.seekg(pos[index]);
		
		char* str = new char[end_pos - pos[index] + 1];
		std::memset(str, 0, end_pos - pos[index] + 1);
		ptr_deleter<char> del(str);
		
		if(!is.read(str, end_pos - pos[index]))
			return std::string();
		
		if(!str)
			return std::string();
		
		std::string s(str);
		for(std::string::reverse_iterator i = s.rbegin(), e = s.rend(); i != e; i++)
		{
			if(*i != '\n' && *i != '\t' && *i != ' ')
			{
				std::string tmp(s.begin(), i.base());
				s = tmp;
				break;
			}
		}
		
		return s;
	}
	
}
