#ifndef PROFDIST_QTGUI_ALIGNMENT_DATA_HPP_
#define PROFDIST_QTGUI_ALIGNMENT_DATA_HPP_

#include <QString>

#include "operation_accessors.hpp"
#include "classification_data.hpp"
#include "debug.hpp"
#include "helper.hpp"

#include "aligncode.h"
#include "parser.h"

namespace gui {
	
	template<typename Traits>
	class AlignmentData :
			//public DataForBootstrap<Traits>, // is inherited by DataForPnj
			public DataForDistance<Traits>,
			public DataForPnj<Traits> //,
			/*public DataItem*/ {
		public:
			typedef typename profdist::AlignCode<Traits> Alignment;
			
									AlignmentData(const QString& name, profdist::AlignCode<Traits>& align);
									~AlignmentData();
			Alignment				alignCode() const;
			bool					writeData(std::ostream& out, profdist::FileType fileType);
			unsigned int			type() const;
			QIcon					icon() const;
			QString					info() const;
			QString					dataToString() const;
			size_t					numBootstraps() const;
			profdist::AlignCode<Traits> bootstrapData(typename DataForDistance<Traits>::index_type index);
			bool					openStream();
			void					closeStream();
			void					addBootstrapAlignment(profdist::AlignCode<Traits>& align);
			std::vector<std::string>	getSequenceNames() const;
			classification_t		getClassificationData() const;
			void					setClassificationData(const profdist::alignment& a);
			
		private:
			Alignment				_alignment;
			classification_t		_classification_data;
	};
	
	template<typename Traits>
	AlignmentData<Traits>::AlignmentData(const QString& name, profdist::AlignCode<Traits>& align)
	: /*DataItem(name),*/ _alignment(align)
	{
		this->setName(name);
	}
	
	template<typename Traits>
	AlignmentData<Traits>::~AlignmentData()
	{
		GUI_MSG_N("AlignmentData object destroyed");
	}
	
	template<typename Traits>
	typename AlignmentData<Traits>::Alignment AlignmentData<Traits>::alignCode() const
	{
		return _alignment;
	}
	
	template<typename Traits>
	bool AlignmentData<Traits>::writeData(std::ostream& out, profdist::FileType fileType)
	{
		switch(fileType)
		{
			case profdist::Fasta:
			case profdist::Embl: profdist::write_file(_alignment, out, fileType); return true;
			default: return false;
		}
	}
	
#ifdef Q_OS_WIN
	template<> QIcon AlignmentData<profdist::rna_traits>::icon() const;
	template<> QIcon AlignmentData<profdist::rna_structure_traits>::icon() const;
	template<> QIcon AlignmentData<profdist::protein_traits>::icon() const;
#endif
	
	template<typename Traits>
	QString AlignmentData<Traits>::dataToString() const
	{
		return alignmentToQString(_alignment);
	}
	
	template<typename Traits>
	size_t AlignmentData<Traits>::numBootstraps() const
	{
		return 1;
	}
	
	template<typename Traits>
	profdist::AlignCode<Traits> AlignmentData<Traits>::bootstrapData(typename DataForDistance<Traits>::index_type index)
	{
		return _alignment;
	}
	
	template<typename Traits>
	bool AlignmentData<Traits>::openStream()
	{
		return true;
	}
	
	template<typename Traits>
	void AlignmentData<Traits>::closeStream()
	{}
	
	template<typename Traits>
	void AlignmentData<Traits>::addBootstrapAlignment(profdist::AlignCode<Traits>& /*align*/)
	{}
	
	template<typename Traits>
	std::vector<std::string> AlignmentData<Traits>::getSequenceNames() const
	{
		return _alignment.get_sequence_names();
	}
	
	template<typename Traits>
	classification_t AlignmentData<Traits>::getClassificationData() const
	{
		return _classification_data;
	}
	
	template<typename Traits>
	void AlignmentData<Traits>::setClassificationData(const profdist::alignment& a)
	{
		_classification_data = ::gui::getClassificationData(a);
	}
	
}

#endif // PROFDIST_QTGUI_ALIGNMENT_DATA_HPP_

