#include "alignment_data.hpp"

namespace gui {
	
	template<> unsigned int AlignmentData<profdist::rna_traits>::type() const
	{
		return DataType::SingleRnaAlignment;
	}
	
	template<> unsigned int AlignmentData<profdist::rna_structure_traits>::type() const
	{
		return DataType::SingleRnaStructureAlignment;
	}
	
	template<> unsigned int AlignmentData<profdist::protein_traits>::type() const
	{
		return DataType::SingleProteinAlignment;
	}
	
	template<> QIcon AlignmentData<profdist::rna_traits>::icon() const
	{
		return QIcon(":/images/64x64/rna.png");
	}
	
	template<> QIcon AlignmentData<profdist::rna_structure_traits>::icon() const
	{
		return QIcon(":/images/64x64/rna_structure.png");
	}
	
	template<> QIcon AlignmentData<profdist::protein_traits>::icon() const
	{
		return QIcon(":/images/64x64/protein.png");
	}
	
	template<> QString AlignmentData<profdist::rna_traits>::info() const
	{
		return QObject::tr("RNA/DNA Alignment with ") + QString().setNum(_alignment.get_num_sequences()) + QObject::tr(" sequences");
	}
	
	template<> QString AlignmentData<profdist::rna_structure_traits>::info() const
	{
		return QObject::tr("RNA/DNA Structure Alignment with ") + QString().setNum(_alignment.get_num_sequences()) + QObject::tr(" sequences");
	}
	
	template<> QString AlignmentData<profdist::protein_traits>::info() const
	{
		return QObject::tr("Protein Alignment with ") + QString().setNum(_alignment.get_num_sequences()) + QObject::tr(" sequences");
	}
	
}

