/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PROFDIST_TYPES_H_INCLUDED
#define PROFDIST_TYPES_H_INCLUDED

#include <set>
#include "fixed_matrix.h" 
namespace profdist {
enum CorrectionModel
{
  Jukes,
  Kimura,
  GTR,
  LogDet,
  UncorrectedP
};


enum ExpMType
{
  Pade, 
  Taylor,
  Eigenvalue
};

enum FZero
{
  Derivation,
  NewtonMethod,
  Robust,
  Parabolic
};

enum FileType
{
  Fasta, Embl, Bdb, Marna, Forester, Ct, DistanceMatrix, Newick, RateMatrix
};

enum TraitType
{
  Rna, RnaStructure, Proteine
};

}
#include "tMatrix.h"  // replace with boost::ublas asap after release
#include "fixed_matrix_math.h" 
namespace profdist {
typedef tMatrix<double> distance_matrix;
typedef std::set<std::pair<std::size_t, std::size_t> > identical_seq_set;
  typedef std::set<std::size_t> profile_set;
}
#endif 
