/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute *
 *   it and/or modify it under the terms of the GNU General Public License *
 *   as published by the Free Software Foundation; either version 2 of the *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BOOST_TRIM_H
#define BOOST_TRIM_H

#include <string>
#include <locale>
#include <algorithm>

namespace boost {
    namespace algorithm {

      /**
       * Non-boost work-a-like for the meantime of conversion 
       */
        std::string trim_copy( std::string const& Input );

        /**
         * Non-boost simple std::string replacer .. 
         * ugly code .. waits for being replaced by boost::string_algo
         */
        std::string replace_all_copy( std::string const & str, char find, char replace );

        /**
         */
        std::string erase_character_copy( std::string const & str, char find );

 
    } // namespace algorithm
} // namespace boost

#endif

