/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute *
 *   it and/or modify it under the terms of the GNU General Public License *
 *   as published by the Free Software Foundation; either version 2 of the *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "traits.hpp"
#include "dnamapper.h"
#include "rna_structure_mapper.hpp"
#include "protein_mapper.hpp"

profdist::rna_structure_traits::cursor::cursor( profdist::sequence<it_type>const& seq
    , profdist::rna_structure_traits::cursor::const_iterator seq_it 
    , profdist::rna_structure_traits::cursor::const_iterator fold ) 
  : seq_it(seq_it), fold_it(fold), seq_end(seq.sequence_data.end()), fold_end(seq.char_fold_data.end())
{
  if( seq_end != seq_it )
    seq_range_it = *seq_it;
  if( fold_end != fold_it )
    fold_range_it = *fold_it;
}

profdist::rna_structure_traits::encoding_type 
profdist::rna_structure_traits::cursor::dereference()	const
{
  rna_structure_mapper & mapper = rna_structure_mapper::get_instance();
  return mapper.to_code( *seq_range_it.first, *fold_range_it.first );
}

namespace profdist {
bool rna_structure_traits::cursor::equal( rna_structure_traits::cursor const& other )const
{
  return ( seq_it == seq_end && other.seq_it == other.seq_end ) 
    || ( seq_range_it.first == other.seq_range_it.first && seq_it == other.seq_it ) ;
}
}


void profdist::rna_structure_traits::cursor::increment() {
  if( seq_it != seq_end ) {
    ++seq_range_it.first;
    if( seq_range_it.second == seq_range_it.first ){
      ++seq_it;
      seq_range_it = *seq_it;
    }
  }
  if( fold_it != fold_end ) {
    ++fold_range_it.first;
    if( fold_range_it.second == fold_range_it.first ){
      ++fold_it;
      fold_range_it = *fold_it;
    }
  }
}

profdist::rna_traits::cursor::cursor( profdist::sequence<it_type>const& seq
    , profdist::rna_traits::cursor::const_iterator it ) 
  : seq_it(it), end(seq.sequence_data.end()) 
{
  if( end != seq_it )
    range_it = *seq_it;
}


profdist::rna_traits::encoding_type 
profdist::rna_traits::cursor::dereference()	const
{
  DNAMapper & mapper = ::get_mapper_instance();
  return mapper.dna2code[*range_it.first];
}


bool profdist::rna_traits::cursor::equal( cursor const& other )const
{
  return ( seq_it == end && other.seq_it == other.end  ) 
    || ( range_it.first == other.range_it.first && seq_it == other.seq_it ) ;
}


void profdist::rna_traits::cursor::increment() {
  if( seq_it != end ) {
    ++range_it.first;
    if( range_it.second == range_it.first ){
      ++seq_it;
      range_it = *seq_it;
    }
  }
}


profdist::protein_traits::cursor::cursor( profdist::sequence<it_type>const& seq
    , profdist::protein_traits::cursor::const_iterator it ) 
  : seq_it(it), end(seq.sequence_data.end()) 
{
  if( end != seq_it )
    range_it = *seq_it;
}


profdist::protein_traits::encoding_type 
profdist::protein_traits::cursor::dereference()	const
{
  protein_mapper& mapper = protein_mapper::get_instance();
  return mapper.to_code( *range_it.first );
}


bool profdist::protein_traits::cursor::equal( cursor const& other )const
{
  return ( seq_it == end && other.seq_it == other.end ) 
    || ( range_it.first == other.range_it.first && seq_it == other.seq_it ) ;
}


void profdist::protein_traits::cursor::increment() {
  if( seq_it != end ) {
    ++range_it.first;
    if( range_it.second == range_it.first ){
      ++seq_it;
      range_it = *seq_it;
    }
  }
}
