#ifndef PROFDIST_RNA_STRUCTURE_MAPPER_HPP_INCLUDED
#define PROFDIST_RNA_STRUCTURE_MAPPER_HPP_INCLUDED

/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <utility>


namespace profdist {

#if 0
/**
 * A simple and open structure to map between dna characters and the code used within profidst.
 */
struct rna_structure_mapper
{
  private:
    unsigned char rna_s_to_code[128]; ///< Maps from rna characters to code numbers
    std::pair<char,char> code_to_rna_s[15]; ///< Maps from core numbers to bracked_dot_brackte numbers
    rna_structure_mapper();
  public:
    static rna_structure_mapper &get_instance();
    inline unsigned char to_code( char rna, char bdb_item ) const 
    { 
      unsigned char e = rna_s_to_code[rna];
      switch( bdb_item ) {
        case '.': return e!=4?e:12; 
        case '(': return e!=4?(e+4):13;
        case ')': return e!=4?(e+8):14;
        case '-': return 15; 
      }
    }
    inline std::pair<char,char> from_code( unsigned char code ) const 
    { return (code < 15 )?code_to_rna_s[code]:std::pair<char,char>('-','-'); }; 
};
#endif

struct rna_structure_mapper
{
  private:
    unsigned char rna_s_to_code[128]; ///< Maps from rna characters to code numbers
    std::pair<char,char> code_to_rna_s[15]; ///< Maps from core numbers to bracked_dot_brackte numbers
    rna_structure_mapper();
  public:
    static rna_structure_mapper &get_instance();
    inline unsigned char to_code( char rna, char bdb_item ) const 
    { 
      unsigned char e = rna_s_to_code[rna];
      switch( bdb_item ) {
      	case '(': return e != 10 ? e : 12;
      	case ')': return e != 10 ? e + 1 : 13;
      	case '.': return e != 10 ? e + 2 : 14;
      	case '-': return 15;
      }
    }
    inline std::pair<char,char> from_code( unsigned char code ) const 
    { return (code < 15 )?code_to_rna_s[code]:std::pair<char,char>('-','-'); }; 
};

}

#endif 
