/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <cstring>
#include "protein_mapper.hpp" 

profdist::protein_mapper::protein_mapper() 
{
  std::memset( prot2code, 20, 128 ); // set all entries to junk code
  prot2code['a'] = 0;
  prot2code['A'] = 0;
  prot2code['r'] = 1;
  prot2code['R'] = 1;
  prot2code['n'] = 2;
  prot2code['N'] = 2;
  prot2code['d'] = 3;
  prot2code['D'] = 3;
  prot2code['c'] = 4;
  prot2code['C'] = 4;
  prot2code['q'] = 5;
  prot2code['Q'] = 5;
  prot2code['e'] = 6;
  prot2code['E'] = 6;
  prot2code['g'] = 7;
  prot2code['G'] = 7;
  prot2code['h'] = 8;
  prot2code['H'] = 8;
  prot2code['i'] = 9;
  prot2code['I'] = 9;
  prot2code['l'] =10;
  prot2code['L'] =10;
  prot2code['K'] =11;
  prot2code['k'] =11;
  prot2code['m'] =12;
  prot2code['M'] =12;
  prot2code['f'] =13;
  prot2code['F'] =13;
  prot2code['p'] =14;
  prot2code['P'] =14;
  prot2code['s'] =15;
  prot2code['S'] =15;
  prot2code['t'] =16;
  prot2code['T'] =16;
  prot2code['w'] =17;
  prot2code['W'] =17;
  prot2code['y'] =18;
  prot2code['Y'] =18;
  prot2code['v'] =19;
  prot2code['V'] =19;
  prot2code['-'] =21;

  code2prot[0] = 'A';
  code2prot[1] = 'R';
  code2prot[2] = 'N';
  code2prot[3] = 'D';
  code2prot[4] = 'C';
  code2prot[5] = 'Q';
  code2prot[6] = 'E';
  code2prot[7] = 'G';
  code2prot[8] = 'H';
  code2prot[9] = 'I';
  code2prot[10] = 'L';
  code2prot[11] = 'K';
  code2prot[12] = 'M';
  code2prot[13] = 'F';
  code2prot[14] = 'P';
  code2prot[15] = 'S';
  code2prot[16] = 'T';
  code2prot[17] = 'W';
  code2prot[18] = 'Y';
  code2prot[19] = 'V';
  code2prot[20] = 'X';
  code2prot[21] = '-';
}

profdist::protein_mapper & profdist::protein_mapper::get_instance() {
  static protein_mapper instance;
  return instance;
}

