/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PROFDIST_PROGRRESS_UPDATE_H_INCLUDED
#define PROFDIST_PROGRRESS_UPDATE_H_INCLUDED

#include <iostream>
#include <string>

namespace profdist{
/**
 * Used within algorithms to stop them, while processing and  to display
 * progress information. The default implementation always returns true.
 */
class ProgressSink
{
  public:
    virtual bool update( std::size_t position, std::string const& status = "");
    virtual ~ProgressSink();

};


class OStreamSink : public ProgressSink 
{
  private:
    std::ostream & out;
    size_t maxi;
  public:
    OStreamSink( std::ostream & out, size_t maxi );
    bool update( std::size_t position, std::string const& status = "");
    ~OStreamSink();

};


}

#endif

