/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <iostream>
#include <sstream>
#include <stdexcept>
#include "newick.h"


void parse_newick( std::string const& filename, std::list<profdist::parsed_node::node_ptr>& trees, std::vector<std::string> & sequence_names )
{
  using namespace boost::spirit;
  typedef char char_t;
  typedef position_iterator<file_iterator<char_t> > iterator_t;
  file_iterator<char_t> file_handle( filename );

  if (!file_handle)
    throw std::runtime_error( ("Unable to open file " + filename) );

  
  iterator_t first( file_handle, file_handle.make_end(), filename );
  iterator_t end( file_handle.make_end(), file_handle.make_end(), filename );


  trees.clear();
  sequence_names.clear();

  boost::shared_ptr<profdist::newick_grammar::sequence_lookup> lookup( new profdist::newick_grammar::sequence_lookup );
 
  boost::spirit::parse_info<iterator_t> info;
  do  {
  	//if(!is_only_ws(std::string(first, end)))
	//{
    trees.push_back( boost::shared_ptr<profdist::parsed_node> ( new profdist::parsed_node ) );
    profdist::newick_grammar grammar( trees.back(), lookup ); 
#ifdef BOOST_SPIRIT_DEBUG
    BOOST_SPIRIT_DEBUG_NODE(grammar);
#endif 
    // Define your rule
	
		info = boost::spirit::parse( first, end, grammar, space_p );
		if( !info.hit )
		{
		  trees.pop_back();
		  sequence_names.resize( lookup->size() );
		  for( profdist::newick_grammar::sequence_lookup::const_iterator it = lookup->begin(), e = lookup->end() ; it != e ; ++ it ) {
		    sequence_names[it->second] = it->first;
		  }
		  
		  /*
		   * Ugly hack to avoid this method from throwing an exception which
		   * shouldn't be thrown.
		   */
		  
		  //return;
		   
		  /*std::ostringstream out;
		  out << "Parsing failed at line " << info.stop.get_position().line << " and column " 
		    << info.stop.get_position().column << " in file " << info.stop.get_position().file 
		    << '\n' << trees.size() << " trees were found.\nError happened near:\n[...]" 
		    << std::string( std::max( first, info.stop - 20 ), info.stop) << '\n';
		  throw std::runtime_error( out.str() );*/
		}
    //}
    first = info.stop;
  }
  while( info.stop != end );

  sequence_names.resize( lookup->size() );
  for( profdist::newick_grammar::sequence_lookup::const_iterator it = lookup->begin(), e = lookup->end() ; it != e ; ++ it ) {
    sequence_names[it->second] = it->first;
  }
}

void parse_newick_from_string( std::string const& data, std::list<profdist::parsed_node::node_ptr>& trees, std::vector<std::string> & sequence_names )
{
	using namespace boost::spirit;
	typedef char char_t;
	typedef position_iterator<const char*> iterator_t;
	
	iterator_t first( data.c_str(), data.c_str() + data.size());
	iterator_t end;


	trees.clear();
	sequence_names.clear();

	boost::shared_ptr<profdist::newick_grammar::sequence_lookup> lookup( new profdist::newick_grammar::sequence_lookup );
 
	boost::spirit::parse_info<iterator_t> info;
	do  {
  	//if(!is_only_ws(std::string(first, end)))
	//{
		trees.push_back( boost::shared_ptr<profdist::parsed_node> ( new profdist::parsed_node ) );
		profdist::newick_grammar grammar( trees.back(), lookup ); 
#ifdef BOOST_SPIRIT_DEBUG
		BOOST_SPIRIT_DEBUG_NODE(grammar);
#endif 
    // Define your rule
	
		info = boost::spirit::parse( first, end, grammar, space_p );
		if( !info.hit )
		{
			trees.pop_back();
			sequence_names.resize( lookup->size() );
			for( profdist::newick_grammar::sequence_lookup::const_iterator it = lookup->begin(), e = lookup->end() ; it != e ; ++ it ) {
				sequence_names[it->second] = it->first;
			}
		  
		  /*
			* Ugly hack to avoid this method from throwing an exception which
			* shouldn't be thrown.
		  */
		  
		  //return;
		   
		  /*std::ostringstream out;
			out << "Parsing failed at line " << info.stop.get_position().line << " and column " 
			<< info.stop.get_position().column << " in file " << info.stop.get_position().file 
			<< '\n' << trees.size() << " trees were found.\nError happened near:\n[...]" 
			<< std::string( std::max( first, info.stop - 20 ), info.stop) << '\n';
			throw std::runtime_error( out.str() );*/
		}
    //}
		first = info.stop;
	}
	while( info.stop != end );

	sequence_names.resize( lookup->size() );
	for( profdist::newick_grammar::sequence_lookup::const_iterator it = lookup->begin(), e = lookup->end() ; it != e ; ++ it ) {
		sequence_names[it->second] = it->first;
	}
}

#ifdef PARSER_TEST
#include <iostream>

int main( int argc, char ** argv )
{
 
  if( argc != 1 )
  {
    std::list<profdist::parsed_node::node_ptr> trees;
    std::vector<std::string> names;
    try {
    parse_newick( argv[1], trees, names );
    }
    catch( std::runtime_error & e )
    {
      std::cout << e.what();
    }

    for( std::list<profdist::parsed_node::node_ptr>::const_iterator it = trees.begin(), e = trees.end();
        it != e; ++it)
    {
      (*it)->print_tree( std::cout, names );
      std::cout << std::endl;
    }
  }
  else 
    std::cout << "Add a file name to the command to test the newick parser" << std::endl;
}


#endif

