/**
 * Macros for debugging output. If debugging should be enabled DEBUG has to be
 * defined otherwise not.
 */

#ifndef DEBUG_H_
#define DEBUG_H_

#ifdef DEBUG
#  define MSG(x) std::cout << "[" << __FILE__ << " " << __LINE__ << "] " << __func__ << ": " << x
#  define MSG_N(x) MSG(x) << std::endl
#else
#  define MSG(x)
#  define MSG_N(x)
#endif

#endif
