#include "traits.hpp"
#include "correction.h"
#include "distance.h"

using namespace std;
using namespace profdist;
int main( int argc, char * argv ) {
  ifstream in("N_matrix");
  protein_traits::rate_matrix N(0);
  read_rate_matrix<protein_traits>(in, N);
  ifstream in2("Q_VTML");
  protein_traits::rate_matrix Q(0);
  read_rate_matrix<protein_traits>(in, Q);
  try{std::cout << "UcorP:" << correction( N, Q, UncorrectedP, Taylor, Robust  ) << std::endl;} catch(...){}
  try{std::cout << "LogDet:" << correction( N, Q, LogDet, Taylor, Robust  ) << std::endl;} catch(...){}
  try{std::cout << "TGTR: Robust: " << correction( N, Q, GTR, Taylor, Robust  ) << std::endl;} catch(...){}
  try{std::cout << "PGTR: Robust:" << correction( N, Q, GTR, Pade, Robust  ) << std::endl;} catch(...){}
  try{std::cout << "PGTR: Newton:" << correction( N, Q, GTR, Pade, NewtonMethod)  << std::endl;} catch(...){}
  try{std::cout << "TGTR: Newton:" << correction( N, Q, GTR, Pade, NewtonMethod) << std::endl;} catch(...){}
  try{std::cout << "PGTR: Parabolic:" << correction( N, Q, GTR, Pade, Parabolic) << std::endl;} catch(...){}
  try{std::cout << "TGTR: Parabolic:" << correction( N, Q, GTR, Taylor, Parabolic) << std::endl;} catch(...){}
  try{std::cout << "TGTR: Derivation:" << correction( N, Q, GTR, Taylor, Derivation) << std::endl;} catch(...){}
  try{std::cout << "PGTR: Derivation:" << correction( N, Q, GTR, Pade, Derivation) << std::endl;} catch(...){}
  try{std::cout << "Jukes:" << correction( N, Q, Jukes, Taylor, Robust  ) << std::endl;} catch(...){}

}
