/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute *
 *   it and/or modify it under the terms of the GNU General Public License *
 *   as published by the Free Software Foundation; either version 2 of the *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "consense.h"
#ifdef PROFDIST_DEBUG
#include <fstream>
#endif

namespace profdist {
namespace impl {
void add_complementary( CountedSets & splits, std::size_t num_seq, CountedSets::set_type const& split ) {
  CountedSets::set_type::const_iterator it = split.begin(), e = split.end();
  CountedSets::set_type complementary;
  for( std::size_t i = 0; i < num_seq; ++i ) {
    if( it != e ) 
      if( *it == i ) ++it;
      else complementary.insert(i);
    else complementary.insert(i);
  }
  splits.add_set( complementary );
}
CountedSets::set_type accumulate_branch( profdist::parsed_node const& tree, CountedSets & splits, std::size_t num_seq ) {
  CountedSets::set_type local_split; 
  for( std::list<profdist::parsed_node::node_ptr>::const_iterator it = tree.childs.begin(), e = tree.childs.end(); 
      it != e; ++it ) {
    if( (*it)->is_leaf() )
      local_split.insert( (*it)->sequence_id );
    else {
      CountedSets::set_type child_split = accumulate_branch( **it, splits, num_seq );
      local_split.insert( child_split.begin(), child_split.end() );
    }
  }
#ifdef  PROFDIST_DEBUG
  std::ofstream deb("debug_data", std::ios::app); 
  print_split_set( deb, local_split );
#endif
  splits.add_set( local_split );
  add_complementary( splits, num_seq, local_split );
  return local_split;
}
}


void get_splits( profdist::parsed_node const& tree, CountedSets & splits, std::size_t num_seq ) {
#ifdef PROFDIST_DEBUG
  std::ofstream deb("debug_data", std::ios::trunc); 
#endif
  for( std::list<profdist::parsed_node::node_ptr>::const_iterator it = tree.childs.begin(), e = tree.childs.end(); 
      it != e; ++it ) 
    if( ! (*it)->is_leaf() )
      CountedSets::set_type child_split = impl::accumulate_branch( **it, splits, num_seq ); 

}

}

