/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parsed_sequence.h"
#include "concepts.h"
#include "parser.h"

int main( int argc, char **argv )
{
  if(argc == 2 )
  {
    using namespace profdist;
    alignment seqs;
    //parse_forester( argv[1], seqs );
    parse_marna( argv[1], seqs );

    typedef sequence_data< name_data< brace_fold_data< num_sequences<base_adaptor> > > > source_t ;
    source_t obj( seqs );

    std::size_t i = 0;
    for( source_t::const_sequence_id it = obj.begin(), e = obj.end(); 
        it != e; ++it )
    {
      ++i;
      std::cout << "ID:" << std::string(obj.get_name( it ).first, obj.get_name( it ).second) << std::endl;
      for( source_t::const_brace_iterator bit = obj.brace_begin( it ), bit_end = obj.brace_end( it ); 
          bit != bit_end; ++ bit )
        std::cout << *bit; 
      std::cout << std::endl;
      for( source_t::const_sequence_iterator sit = obj.sequence_begin( it ), sit_end = obj.sequence_end( it ); 
          sit != sit_end; ++ sit )
        std::cout << *sit; 
      std::cout<< std::endl << i << std::endl;
    }


  }
}
