/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "bdb_parser.h"
#include "file_resources.hpp"

#if 0
void parse_bdb( string const& filename, list<file_sequence>& sequences )
{
  using namespace boost::spirit;
  typedef char char_t;
  typedef position_iterator<file_iterator<char_t> > iterator_t;
  file_iterator<char_t> file_handle( filename );

  if (!file_handle)
    throw runtime_error( ("Unable to open file " + filename) );

  
  iterator_t first( file_handle, file_handle.make_end(), filename );
  iterator_t end( file_handle.make_end(), file_handle.make_end(), filename );


  bdb_grammar grammar( sequences ); 
#ifdef BOOST_SPIRIT_DEBUG
  BOOST_SPIRIT_DEBUG_NODE(grammar);
#endif 
  // Define your rule

  boost::spirit::parse_info<iterator_t> info = boost::spirit::parse( first, end, grammar);
  if( !info.full )
  {
    ostringstream out;
    out << "Parsing failed at line " << info.stop.get_position().line << " and column " 
      << info.stop.get_position().column << " in file " << info.stop.get_position().file 
      << '\n' << sequences.size() << " Sequences were found.\nError happened near:\n[...]" 
      << string( max( first, info.stop - 20 ), info.stop) << '\n';
    throw runtime_error( out.str() );
  }
}
#endif 
namespace profdist {
void parse_bdb(  std::string const& filename, alignment & align )
{
  alignment::file_resource ptr;
/*
  try {
    */
    ptr.reset( new memory_resource(filename));
  /*}
  catch( runtime_error const &e ) {
  // try fallback .. 
  }
    */
  align.reset( ptr );

  using namespace boost::spirit;
  using namespace std;

  bdb_grammar grammar( align ); 
#ifdef BOOST_SPIRIT_DEBUG
  BOOST_SPIRIT_DEBUG_NODE(grammar);
#endif 
  // Define your rule

  boost::spirit::parse_info<char*> info = boost::spirit::parse( ptr->begin(), ptr->end(), grammar);

  if( !info.full )
  {
    using boost::spirit::position_iterator;
    typedef position_iterator<char*> iterator_t;

    ostringstream out;
    iterator_t first( ptr->begin(), ptr->end(), filename);
    while( &*first != info.stop ) ++first;
    out << "Parsing failed at line " << first.get_position().line << " and column " 
      << first.get_position().column << " in file " << filename
      << '\n' << align.size() << " Sequences were found.\nError happened near:\n" 
      << string( max( ptr->begin(), info.stop - 20 ), min( ptr->end(), info.stop + 20) ) << '\n';
    throw runtime_error( out.str() );
  }
}

}
#ifdef PARSER_TEST
#include <iostream>

int main( int argc, char ** argv )
{
 
    using namespace profdist;
    using namespace std;
  if( argc != 1 )
  {


    alignment seqs;
    try {
      parse_bdb( argv[1], seqs );
    }
    catch( runtime_error & e )
    {
      cout << e.what();
      return 1;
    }

    for( alignment::const_iterator it = seqs.begin(), e = seqs.end();
        it != e; ++it)
    {
      cout << "ID:" << string(it->id.first, it->id.second) << endl;
      cout << "CLASSIFCATION:" << endl;
      for( list<alignment::value_type::string_range>::const_iterator _it = it->classification.begin(),
          _e = it->classification.end();
          _it != _e; ++_it )
        cout << '|' << string(_it->first, _it->second ) << "|";
      cout << endl << "SEQUENCE:" << endl;
      for( list<alignment::value_type::string_range>::const_iterator _it = it->sequence_data.begin(),
          _e = it->sequence_data.end();
          _it != _e; ++_it )
        cout << '|' << string(_it->first, _it->second ) << "|";
      cout << endl;
      cout << endl << "Folding:" << endl;
      for( list<alignment::value_type::string_range>::const_iterator _it = it->char_fold_data.begin(),
          _e = it->char_fold_data.end();
          _it != _e; ++_it )
        cout << '|' << string(_it->first, _it->second ) << "|";

      cout << endl;
    }
  }
  else 
    cout << "Add a file name to the command to test the bdb parser" << endl;
}


#endif

