#ifndef PROFDIST_QTGUI_WORKSPACE_TREE_VIEW_HPP_
#define PROFDIST_QTGUI_WORKSPACE_TREE_VIEW_HPP_

#include <QTreeView>
#include <QPoint>
#include <QItemDelegate>

class QMenu;
class QContextMenuEvent;
class QMouseEvent;
class QWidget;

namespace gui {
	
	class ItemEditDelegate : public QItemDelegate {
			Q_OBJECT
		public:
			ItemEditDelegate(QObject* parent = 0);
			QWidget* createEditor(QWidget* parent, const QStyleOptionViewItem& option, const QModelIndex& index) const;
			void setEditorData(QWidget* editor, const QModelIndex& index) const;
			void setModelData(QWidget* editor, QAbstractItemModel* model, const QModelIndex& index) const;
			void updateEditorGeometry(QWidget* editor, const QStyleOptionViewItem& option, const QModelIndex& index) const;
	};
	
	class WorkspaceTreeView : public QTreeView {
			Q_OBJECT
		public:
			WorkspaceTreeView(QWidget* parent = 0);
			
		Q_SIGNALS:
			void showContextMenu();
			void updateFeatures();
			
		protected:
			void contextMenuEvent(QContextMenuEvent* e);
			void mousePressEvent(QMouseEvent* e);
			
		private:
			QMenu				*_context_menu;
	};
	
}

#endif // PROFDIST_QTGUI_WORKSPACE_TREE_VIEW_HPP_

