#ifndef PROFDIST_QTGUI_WORKSPACE_TREE_MODEL_HPP_
#define PROFDIST_QTGUI_WORKSPACE_TREE_MODEL_HPP_

//#include "tree_item.hpp"
#include "data_item.hpp"
#include "types.h"
#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>
#include <string>

class QWidget;

namespace gui {
	
	class RootItem : public DataItem {
		public:
			RootItem();
			unsigned int type() const;
			bool readData(const std::string& fileName, profdist::FileType fileType);
			bool writeData(std::ostream& out, profdist::FileType fileType);
			QString dataToString() const;
	};
	
	class WorkspaceTreeModel : public QAbstractItemModel {
			Q_OBJECT
		public:
			typedef DataItem ConcreteTreeItem;
			
								WorkspaceTreeModel(QObject* parent = 0);
								~WorkspaceTreeModel();
			
			QModelIndex			treeNodeToIndex(const ConcreteTreeItem* node) const;
			ConcreteTreeItem*	indexToTreeNode(const QModelIndex& index) const;
			
			int					columnCount(const QModelIndex& parent = QModelIndex()) const;
			QVariant			data(const QModelIndex& index, int role = Qt::DisplayRole) const;
			QVariant			headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
			QModelIndex			index(int row, int column, const QModelIndex& parent = QModelIndex()) const;
			QModelIndex			parent(const QModelIndex& index) const;
			int					rowCount(const QModelIndex& parent = QModelIndex()) const;
			Qt::ItemFlags		flags(const QModelIndex& index) const;
			bool				setData(const QModelIndex& index, const QVariant& value, int role);
			
			void				addNode(ConcreteTreeItem* new_node, ConcreteTreeItem* parent = 0);
			void				removeNode(ConcreteTreeItem* node);
			
		Q_SIGNALS:
			void				expandNode(const QModelIndex& index);
			
		private:
			ConcreteTreeItem	*_root;
			
	};
	
}

#endif // PROFDIST_QTGUI_WORKSPACE_TREE_MODEL_HPP_

