#include "tree_selection_dialog.hpp"
#include "main_window.hpp"
#include "debug.hpp"

#include <QSettings>
#include <QProcess>
#include <QMessageBox>

namespace gui {
	
	TreeSelectionDialog::TreeSelectionDialog(QStringList trees, QWidget* parent)
	: QDialog(parent), _trees(trees), _file("tree_selection_XXXXXX.tre")
	{
		setupUi(this);
		
// 		if(!_file.open())
// 		{
// 			GUI_MSG_N("could not open temporary file");
// 		}
		
		connect(pushButton, SIGNAL(clicked()), this, SLOT(viewTree()));
		
		for(int i = 1; i <= trees.size(); i++)
		{
			comboBox->addItem(QString().setNum(i));
		}
	}
	
	TreeSelectionDialog::~TreeSelectionDialog()
	{
		foreach(QProcess* process, _processes)
		{
			if(process)
			{
				process->kill();
				process->waitForFinished();
				delete process;
			}
		}
	}
	
	void TreeSelectionDialog::viewTree()
	{
		QString tree = _trees.at(comboBox->currentIndex());
		
		if(!_file.open())
		{
			GUI_MSG_N("Could not open temporary file");
			return;
		}
		
		_file.resize(0);
		_file.write(tree.toStdString().c_str(), tree.toStdString().size());
		
		QString fileName = _file.fileName();
		
		_file.close();
		
		QSettings settings;
		
		QString njplotBin = settings.value("tree_viewer/njplot").toString();
		
		if(njplotBin == "")
		{
			QMessageBox::information(mainWindow, QObject::tr("No viewer"), QObject::tr("Path to executable not specified.\nPlease check the settings."));
			return;
		}
		
		/*
		QStringList viewers = settings.value("settings/tree_viewer").toStringList();
		if(viewers.empty())
		{
			mainWindow->showMessage(QObject::tr("Could not open tree in extern viewer because\nno viewer were specified in the settings."));
			return;
		}
		*/
		
		QProcess* process = new QProcess(mainWindow);
		process->start(njplotBin, QStringList() << fileName);
		_processes.push_back(process);
	}
	
}
