#ifndef PROFDIST_QTGUI_TREE_ITEM_HPP_
#define PROFDIST_QTGUI_TREE_ITEM_HPP_

#include <list>

namespace gui {
	
	namespace {
		const int IdCounterStart = 1;
	}
	
	template<typename T>
	struct ChildDeleter;
	
	class WorkspaceTreeModel;
	
	template<typename T>
	class TreeItem {
		public:
			typedef std::list<T*> TreeItemList;
			
			/*
			 * Ctor and Dtor.
			 */
							TreeItem();
			virtual			~TreeItem();
			
			/*
			 * Basic tree manipulation operations.
			 */
		private:
			friend class WorkspaceTreeModel;
			
			void			addChild(T* child);
			void			removeChild(T* child);
		public:
			T*				parent() const;
			T*				child(size_t index);
			int				id() const;
			T*				find(int id);
			T*				findRecursive(int id);
			size_t			childCount() const;
			int				indexOf(const T* child) const;
			size_t			index() const;
			
			/*
			 * Returns a list of observed TreeItems.
			 */
			static TreeItemList	getPendingItems();
			static TreeItemList	getBoundItems();
			
		protected:
			/*
			 * 
			 */
			static int		getNewId();
			static void		addPendingItem(T* item);
			static void		switchToBound(T* item);
			static void		switchToPending(T* item);
			static void		removeItemFromObserver(T* item);
			
		private:
			friend struct ChildDeleter<T>;
			
			/*
			 * No copy constructor and copy operator.
			 */
							TreeItem(const TreeItem& item);
			TreeItem&		operator=(const TreeItem& item);
							
			const int				_id;
			TreeItemList			_children;
			T						*_parent;
			
			/*
			 * Observer stuff:
			 */
			static TreeItemList		_pending_items;
			static TreeItemList		_bound_items;
			
	};
	
}

#include "tree_item.Tpp"

#endif // PROFDIST_QTGUI_TREE_ITEM_HPP_

