#ifndef PROFDSIST_QTGUI_TASK_MANAGER_HPP_
#define PROFDSIST_QTGUI_TASK_MANAGER_HPP_

#include <map>
#include <QObject>
#include <QMutex>
#include "task.hpp"

class QWidget;

namespace gui {
	
	class OperationInterface;
	class Workspace;
	class ProgressSink;
	
	/**
	 * Stores and manages Task-objects.
	 */
	class TaskManager : public QObject {
			Q_OBJECT
		public:
			/**
			 * Constructor
			 * @param mainWindow Pointer to Workspace which is used
			 * to act as the parent of the TaskManager
			 */
			TaskManager(Workspace* workspace);
			
			/**
			 * Cancels all running tasks and destroys the TaskManager.
			 */
			~TaskManager();
			
			/**
			 * Adds a new task to the manager and executes it in its own thread
			 * context.
			 * @param operation The new operation object to be computed.
			 * @param progress specifies if a progress bar is displayed
			 */
			void addTask(OperationInterface* operation, bool showProgress = true);
			
			/**
			 * @return Returns true if there are still running tasks.
			 */
			bool hasRunningTasks() const;
			
			/**
			 * Resumes a paused task.
			 */
			void resumeTask(unsigned int taskId);
			
		public Q_SLOTS:
			/**
			 * Removes the task with taskId from the list of running tasks and
			 * destroys the Task object.
			 */
			void removeTask(unsigned int taskId);
		
		private:
			struct Item {
				boost::shared_ptr<Task> task;
				boost::shared_ptr<ProgressSink> sink;
			};
			
			Workspace						*_workspace;
			std::map<unsigned int, Item>	_tasks;
			QMutex							_mutex_tasks;
	};
	
}

#endif // PROFDSIST_QTGUI_TASK_MANAGER_HPP_

