#ifndef PROFDIST_QTGUI_TASK_CONTAINER_WIDGET_HPP_
#define PROFDIST_QTGUI_TASK_CONTAINER_WIDGET_HPP_

#include <QObject>
#include <QFrame>
#include <QScrollArea>

class QLabel;
class QProgressBar;
class QToolButton;
class QResizeEvent;
class QVBoxLayout;

namespace gui {
	
	class OperationInterface;
	class TaskContainerWidget;
	class Task;
	
	//namespace {
		
		class TaskProgressWidget : public QFrame {
				Q_OBJECT
			public:
				TaskProgressWidget(TaskContainerWidget* container = 0);
				~TaskProgressWidget();
				
			Q_SIGNALS:
				void cancelTask();
				void resumeTask();
				void closeDialog();
				
			public Q_SLOTS:
				void taskPaused();
				void deleteProgressWidget();
				void cancelButtonClicked();
				void setMaximumValue(unsigned int maximumValue);
				void updateProgress(unsigned int value);
				void updateProgress(const QString message);
				
			private:
				QLabel					*_label;
				QProgressBar			*_progress_bar;
				QToolButton				*_cancel_button;
				QToolButton				*_resume_button;
				TaskContainerWidget		*_container;
		};
		
	//}
	
	class TaskContainerWidget : public QScrollArea {
		public:
			TaskContainerWidget(QWidget* parent = 0);
			void trackProgressOfTask(Task* task);
			void removeTaskProgressWidget(TaskProgressWidget* widget);
			
		protected:
			void addTaskProgressWidget(TaskProgressWidget* progressSink);
			void resizeEvent(QResizeEvent* event);
			
		private:
			QVBoxLayout			*_layout;
			QWidget				*_w;
			
	};
	
}

#endif // PROFDIST_QTGUI_TASK_CONTAINER_WIDGET_HPP_

