#include <QtCore/QSettings>
#include "runtime_settings.hpp"

gui::RuntimeSettings::RuntimeSettings()
{
	QSettings settings;
	num_bootstraps =  settings.value("settings/num_bootstraps", 100).toInt();
	rate_matrix = settings.value("settings/rate_matrix").toString().toUtf8().data();
	expm = profdist::ExpMType( settings.value("settings/matrix_exponential", 1).toInt() );
	fz = profdist::FZero( settings.value("settings/function_maximization", 0).toInt() );
	model = profdist::CorrectionModel( settings.value("settings/correction_model", 0).toInt() );
	bootstrap_threshold = settings.value("settings/bootstrap_threshold", 75).toInt();
	identity_threshold = settings.value("settings/identity_threshold", 90).toInt();
	profile_generation = settings.value("settings/profile_generation", 0).toInt();
	preselect_profiles = (settings.value("settings/select_profiles", 0).toInt() != 0);
}
