#ifndef PROFDIST_QTGUI_PROFILE_SELECTION_DIALOG_HPP_
#define PROFDIST_QTGUI_PROFILE_SELECTION_DIALOG_HPP_

#include "ui_profile_selection_2.h"
#include "ui_small_profile_selection_2.h"
#include "classification_data.hpp"
#include "types.h"
#include <list>
#include <vector>
#include <functional>
#include <QTreeWidgetItem>

namespace gui {
	
	//namespace {
		
		class TreeNode : public QTreeWidgetItem {
			public:
				TreeNode(const QString& name, int id, size_t sequence_count = 0);
				TreeNode(const std::string& name, int id, size_t sequence_count = 0);
				void incrementSequenceCount(int step = 1);
				QString getName() const;
				int getId() const;
				size_t getSequenceCount() const;
				void clear();
				
			private:
				QString				_name;
				int					_id; // ids >= 0 represent a real sequence, -1 stands for classification nodes.
				size_t				_sequence_count;
		};
		
		class ProfileTreeNode : public TreeNode {
			public:
				ProfileTreeNode(const QString& name, int id, size_t sequence_count = 0);
				ProfileTreeNode(const std::string& name, int id, size_t sequence_count = 0);
		};
	//}
	
	class ProfileSelectionDialog : public QDialog, public Ui::ProfileSelectionDialog {
			Q_OBJECT
		public:
			typedef std::list<std::list<size_t> > profile_list_t;
			typedef std::vector<std::string> profile_names_t;
			typedef std::list<std::list<std::string> > profile_sequence_names_t;
			typedef std::vector<std::string> sequences_t;
			
			enum PnjMethod {
				Manual,
				HalfAutomaticEveryStep,
				HalfAutomaticFirstStep,
				Automatic
			};
			
			ProfileSelectionDialog(const sequences_t& sequences,
				const classification_t& class_data,
				bool noKimura = false,
				QWidget* parent = 0);
				
			void setupSequencesTree(const sequences_t& sequences,
				const classification_t& class_data);
			
			void getProfiles(profile_list_t& profiles,
				profile_names_t& profile_names,
				profile_sequence_names_t& profile_sequence_names);
			
			void getSingleProfile(TreeNode* item,
				std::list<size_t>& sequence_numbers,
				std::list<std::string>& sequence_names);
			
			void traverseClassificationNode(TreeNode* item,
				profile_list_t& profiles,
				profile_names_t& profile_names,
				profile_sequence_names_t& profile_sequence_names);
			
			void buildRemainingProfiles();
			
			profdist::CorrectionModel correctionModel() const;
			
		public Q_SLOTS:
			void correctionModelSelectionChanged(int index);
			void createProfile();
			void resetProfiles();
			void getRateMatrixFile();
			void testProfiles();
			void editItem(QTreeWidgetItem* item, int column);
		
		private:
			sequences_t			_sequences;
			classification_t	_class_data;
			size_t				_profile_counter;
			TreeNode			*_sequences_root;
			TreeNode			*_profiles_root;
			bool				_no_kimura;
			
	};
	
	
	class SmallProfileSelectionDialog : public QDialog, public Ui::SmallProfileSelectionDialog {
		Q_OBJECT
		public:
			typedef std::list<std::list<size_t> > profile_list_t;
			typedef std::vector<std::string> profile_names_t;
			typedef std::list<std::list<std::string> > profile_sequence_names_t;
			typedef std::vector<std::string> sequences_t;
			
			SmallProfileSelectionDialog(const sequences_t& sequences,
										const classification_t& class_data,
										QWidget* parent = 0);
			
			SmallProfileSelectionDialog(QWidget* parent = 0);
				
			void setupSequencesTree(const sequences_t& sequences,
									const classification_t& class_data);
			
			void getProfiles(profile_list_t& profiles,
							 profile_names_t& profile_names,
		profile_sequence_names_t& profile_sequence_names);
			
			void getSingleProfile(TreeNode* item,
								  std::list<size_t>& sequence_numbers,
		  std::list<std::string>& sequence_names);
			
			void traverseClassificationNode(TreeNode* item,
											profile_list_t& profiles,
		   profile_names_t& profile_names,
	 profile_sequence_names_t& profile_sequence_names);
			
			void buildRemainingProfiles();
			
		public Q_SLOTS:
			void createProfile();
			void resetProfiles();
			void testProfiles();
			void editItem(QTreeWidgetItem* item, int column);
		
		private:
			sequences_t			_sequences;
			classification_t	_class_data;
			size_t				_profile_counter;
			TreeNode			*_sequences_root;
			TreeNode			*_profiles_root;
			
	};
	
}

#endif // PROFDIST_QTGUI_PROFILE_SELECTION_DIALOG_HPP_
