#include "profile_neighbour_joining_operation.hpp"


namespace gui {
	
	template<> bool ProfileNeighbourJoiningOperation<profdist::rna_traits>::preExecution()
	{
		RuntimeSettings settings;
		
		ProfileSelectionDialog dialog(_data_for_pnj->getSequenceNames(), _data_for_pnj->getClassificationData(), false, mainWindow);
		dialog._label_icon->setPixmap(_data_for_pnj->icon().pixmap(dialog._label_icon->size()));
		dialog._label_sequence_name->setText(_data_for_pnj->name());
		//dialog._combo_box_generation_method->setCurrentIndex(settings.profile_generation);
		dialog._spin_box_minimal_bootstrap->setValue(settings.bootstrap_threshold);
		dialog._spin_box_identity->setValue(settings.identity_threshold);
		
		if(QDialog::Rejected == dialog.exec())
			return false;
		
		_num_bootstraps = static_cast<size_t>(dialog._spin_box_num_bootstraps->value());
		_correction = dialog.correctionModel();
		_filename_rate_matrix = dialog._line_edit_rate_matrix->text();
		_pnj_method =  ProfileSelectionDialog::PnjMethod(dialog._combo_box_generation_method->currentIndex());
		_threshold_minimum_bootstrap = static_cast<size_t>(dialog._spin_box_minimal_bootstrap->value());
		_threshold_identity = static_cast<size_t>(dialog._spin_box_identity->value()); 
		
		dialog.getProfiles(_profiles, _profile_names, _profile_sequence_names);
		
		// Initialize the profile
		_profile = new profdist::Profile(_data_for_pnj->alignCode(), _profiles);
		
		return true;
	}
	
}

