#include "profile_neighbour_joining_data.hpp"
#include "data_type.hpp"
#include "debug.hpp"

namespace gui {
	
	ProfileNeighbourJoiningData::ProfileNeighbourJoiningData(const QString& name, const std::string& data)
	: _data(data)
	{
		this->setName(name);
	}
	
	ProfileNeighbourJoiningData::~ProfileNeighbourJoiningData()
	{
		GUI_MSG_N("ProfileNeighbourJoiningData object destroyed");
	}
	
	unsigned int ProfileNeighbourJoiningData::type() const
	{
		return DataType::PnjTree;
	}
	
	QIcon ProfileNeighbourJoiningData::icon() const
	{
		return QIcon(":/images/64x64/pnj.png");
	}
	
	QString ProfileNeighbourJoiningData::info() const
	{
		return QObject::tr("Profile Neighbour Joining Tree");
	}
	
	QString ProfileNeighbourJoiningData::dataToString() const
	{
		return QString(_data.c_str());
	}
	
	bool ProfileNeighbourJoiningData::writeData(std::ostream& out, profdist::FileType /*fileType*/)
	{
		out << _data;
		return true;
	}
	
}
