#include "operation_interface.hpp"
#include "workspace.hpp"
#include "task.hpp"
#include <QString>

namespace gui {
	
	OperationInterface::OperationInterface()
	: _do_cancel(false), _task(0)
	{}
	
	OperationInterface::~OperationInterface()
	{}
	
	void OperationInterface::cancel()
	{
		_do_cancel = true;
	}
	
	bool OperationInterface::isCanceled() const
	{
		return _do_cancel;
	}
	
	void OperationInterface::pause(int guiHandleId, GuiHandleData* data)
	{
		if(_task)
			_task->pause(guiHandleId, data);
	}
	
	void OperationInterface::setTask(Task* task)
	{
		_task = task;
	}
	
	Task* OperationInterface::task()
	{
		return _task;
	}
	
	bool OperationInterface::preExecution()
	{
		return true;
	}
	
	void OperationInterface::addDataItem(DataItem* newNode, DataItem* parentNode)
	{
		if(_task)
			_task->addDataItem(newNode, parentNode);
	}
	
	size_t OperationInterface::maximumValue() const
	{
		return _maximum_value;
	}
	
	void OperationInterface::setMaximumValue(size_t maximumValue)
	{
		_maximum_value = maximumValue;
		if(_task)
			_task->setMaximumValue(maximumValue);
	}
	
	void OperationInterface::updateProgress(size_t value)
	{
		if(_task)
			_task->updateProgress(value);
	}
	
	void OperationInterface::updateProgress(const QString& message)
	{
		if(_task)
			_task->updateProgress(message);
	}
	
	void OperationInterface::showErrorMessage(const std::string& message)
	{
		showErrorMessage(QString(message.c_str()));
	}
	
	void OperationInterface::showErrorMessage(const QString& message)
	{
		if(_task)
			_task->showErrorMessage(message);
	}
}

