#ifndef PROFDIST_QTGUI_OPERATION_ACCESSORS_HPP_
#define PROFDIST_QTGUI_OPERATION_ACCESSORS_HPP_

#include "aligncode.h"
#include "types.h"
#include "data_item.hpp"
#include "debug.hpp"
#include "classification_data.hpp"
#include <QString>

namespace gui {
	
	template<typename Traits>
	class DataForBootstrap : public virtual DataItem {
		public:
			virtual ~DataForBootstrap() {}
			virtual profdist::AlignCode<Traits> alignCode() const = 0;
	};
	
	template<typename Traits>
	class DataForDistance : public virtual DataItem {
		public:
			typedef unsigned long int index_type;
			
			virtual ~DataForDistance() {}
			virtual size_t numBootstraps() const = 0;
			virtual profdist::AlignCode<Traits> bootstrapData(index_type index) = 0;
			virtual bool openStream() = 0;
			virtual void closeStream() = 0;
			virtual void addBootstrapAlignment(profdist::AlignCode<Traits>& align) = 0;
	};
	
	class DataForNj : public virtual DataItem {
		public:
			typedef std::vector<std::string> sequence_names_t;
			
			virtual ~DataForNj() {}
			virtual sequence_names_t getSequenceNames() const = 0;
			virtual profdist::distance_matrix getDistanceMatrix(size_t index) const = 0; 
			virtual size_t getNumMatrices() const = 0;
	};
	
	class DataForConsensus : public virtual DataItem {
		public:
			virtual ~DataForConsensus() {}
			virtual size_t getNumTrees() const = 0;
			virtual std::vector<std::string> getTrees() const = 0;
			virtual std::vector<std::string> getSequenceNames() const = 0;
	};
	
	template<typename Traits>
	class DataForPnj : public DataForBootstrap<Traits> {
		public:
			virtual ~DataForPnj() {}
			virtual std::vector<std::string> getSequenceNames() const = 0;
			virtual classification_t getClassificationData() const = 0;
	};
}

#endif // PROFDIST_QTGUI_OPERATION_ACCESSORS_HPP_

